/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////

var checkInProgress = false;
var cancelCheck = false;
var httpRequestTimeout;
var xmlhttp = null;
var feedsToCheck = new Array();
var newItemsCount = 0;

////////////////////////////////////////////////////////////////
// Check feeds
////////////////////////////////////////////////////////////////

function doCancelCheckFeeds()
{
  if (checkInProgress) cancelCheck = true;
}

function precheckFeed(feedsToCheck)
{
  var url = feedsToCheck.shift();

  if (url == null)
  {
    if (checkInProgress) postRefresh();
    return;
  }

  var i=model.size();
  while(model.get(--i).url != url) if (i==0) precheckFeed(feedsToCheck);
  var index = i;

// TODO using this causes article pane to reset, checking feed with categories
//     open is okay?, but may not be displaying all categories afterward
//     I didn't like the jumping around of the feedtree with this in either
// closes feed before checking as # of categories may change
//  var feedtree = document.getElementById("newsfox.feedTree");
//  var row = feedtree.currentIndex;
//  if (row != -1)
//  {
//    var curGrp = fdgpidx[row];
//    var nFeed = feedidx[row];
//    i= feedidx.length;
//    while (--i >= 0)
//      if (feedidx[i] == index && openidx[i] == true)
//        feedtree.view.toggleOpenState(i);
//    refreshModelSelect(getFeedRow(curGrp,nFeed));
//  }

  var elem = document.getElementById("busyTextNumbers");
  elem.value = (numToCheck-feedsToCheck.length) + " / " + numToCheck;

  var feed = model.get(index);
  feed.error = ERROR_OK;

	var httpicon = document.getElementById("newsfox-icon");
	httpicon.src = feed.icon.src;
	httpicon.width = 16;
	httpicon.height = 16;

  xmlhttp = new XMLHttpRequest();
  url = feed.url;
  // trick of adding the current time to bypass the cache; suggested by Konstantin Svist
	// Commented out since 0.6.4 because of problems the trick caused with different feeds
	// url += (url.match(/\?/) == null ? '?' : '&') + (new Date()).getTime();
	// Instead, Ron Pruitt proposed to put it as experienced user option to replace:
	url = url.replace(/%CURRENT_DATETIME%/, (new Date()).getTime());

  xmlhttp.open("get", url);
  xmlhttp.setRequestHeader("User-Agent", "Mozilla/5.0 NewsFox/0.6");
  xmlhttp.overrideMimeType("application/xml");
  // TODO: do error handling
  // xmlhttp.onerror = foo;
  xmlhttp.onload = function() { checkFeed(index, xmlhttp.responseXML,feedsToCheck); }

		httpRequestTimeout = setTimeout(this.abortHttpRequest, options.refreshTimeout);
  // the next line doesn't have any effect :( Any other ideas how to bypass the cache?
  // xmlhttp.channel.loadFlags = Components.interfaces.nsICachingChannel.LOAD_BYPASS_CACHE;
  xmlhttp.send(null);
}

function checkFeed(index, xml, feedsToCheck)
{
	if(null != httpRequestTimeout)
		clearTimeout(httpRequestTimeout);
  try
  {
    var feed = model.get(index);
		loadFeed(feed);

    var parser = new Parser(xml);
		var refreshingDispFeed = false;
		if ((collect.type == 1 || collect.type == 2) && feed == collect.getFeed(0))
			refreshingDispFeed = true;
    if (parser.title != null) 
      feed.defaultName = encodeString(parser.title);
		if (refreshingDispFeed)
		{
			var title = document.getElementById("feedTitle");
			title.value = entityDecode(feed.getDisplayName());
		}
		if (feed.homepage == null || feed.homepage == "")
			feed.homepage = encodeUrl(parser.link);
		downloadIcon(feed);

    var oldestEntryDate = new Date();
		var now = new Date();

    for (var i=0; i<parser.items.length; i++)
    {
      var item = parser.items[i];
      if ("" != item.pubDate)
			{
				if (oldestEntryDate > item.pubDate)
					oldestEntryDate = item.pubDate;
				if (item.pubDate > now)
					item.pubDate = now;
			}

      if (doesArticleExist(feed, item.link)) continue;

			newItemsCount++;
      var art = new Article();
      art.title = encodeString(item.title);
      art.link = item.link;
      art.date = item.pubDate;
      art.body = encodeString(item.content);
      // AG: added category
      art.category = encodeString(item.category);

      if (art.date == "") art.date = new Date();
      if (art.title == "") art.title = (item.content != "") ? encodeString(item.content.substr(0, 70)) + "..." : "...";

      feed.add(art);
    }

	// Need to turn off article pane here if it is from this feed since
	// collection and feed won't agree once we start deleting and sorting
	// adding articles above is okay since disagreement is at the end
			var refreshingDispColl = false;
			if ((collect.type == 1 || collect.type == 2) && feed == collect.getFeed(0))
				refreshingDispColl = true;
			else if (collect.type == 0 || collect.type == 3)
			{
				var curGrp = feedGroup[collect.grpindex];
				for (i=0; i<curGrp.list.length; i++)
					if (index == curGrp.list[i]) refreshingDispColl = true;
			}
		if (refreshingDispColl)
		{
    	var arttree = document.getElementById("newsfox.articleTree");
			arttree.view = null;  // will be replaced with new one, no need to save
		}

    // AG: delete old not flagged entries if needed, optionally leaving unread
    if (feed.deleteOld)
    {
      var feedSize = feed.size();
      for (i=0; i<feedSize; i++)
      {
        art = feed.get(i);
        if ((art.date < oldestEntryDate) && !feed.isFlagged(i))
        {
					if( !feed.dontDeleteUnread || feed.isRead(i) )
					{
						feed.remove(i--);
						feedSize--;
					}
        }
      }
    }
		for (i=feed.deletedsize()-1; i>=0; i--)
			if (feed.deletedget(i).date < oldestEntryDate)
				feed.deletedremove(i);

		var sortcollect = new NormalCollection(index,0,false);  // index of feed
		sortcollect.artSort("date","descending");
    feed.sortCategories();
    saveFeed(feed);
		saveFeedModel();   // keep flags synchronized on disk
  }
  catch (err) 
  {
    feed.error = err;
    feed.error += "<p><a href='" + feed.url + "'>" + feed.url + "</a>";
  }

  // Update Title, feedTree, and articleTree if current feed
	newTitle(feedGroup[0].getUnread());
	var feedtree = document.getElementById("newsfox.feedTree");
	feedtree.treeBoxObject.invalidate();
	if (refreshingDispColl)
    feedSelected();  // replaces arttree.view with new one

  if (!cancelCheck)  // Check next feed
    precheckFeed(feedsToCheck);
  else              // We're done!
    postRefresh();
}

function abortHttpRequest()
{
	xmlhttp.abort();
	if (!cancelCheck)
		precheckFeed(feedsToCheck);
	else
		postRefresh();
}

function postRefresh()
{
  var elem = document.getElementById("busyAnimation");
  elem.style.visibility = "hidden";
  checkInProgress = false;
  cancelCheck = false;
  feedsToCheck.length = 0;
	if( options.autoRefresh )
		autoRefreshTimer = setTimeout(this.checkFeeds, options.autoRefreshInterval * 60 * 1000);
	if( options.notifyUponNew )
		reportRefreshResults();
}

function reportRefreshResults()
{
	var unreadTotalCount = feedGroup[0].getUnread();
	if( newItemsCount > 0 )
	{
		var stringsBundle = document.getElementById("newsfox-string-bundle");
		var strNew = stringsBundle.getString('alert.new');
		var strUnread = stringsBundle.getString('alert.unread');
		var message = newItemsCount + " " + strNew + ", " + unreadTotalCount + " " + strUnread;
		var alerts = Components.classes["@mozilla.org/alerts-service;1"]
                          .getService(Components.interfaces.nsIAlertsService);
		alerts.showAlertNotification("chrome://newsfox/skin/newsfox-32.png", "NewsFox", message, false, "", null);
	}
}

////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

/**
 * Encode unicode characters to XML-friendly format.
 */
function encodeString(s) 
{
	if( !s ) return "";
  for (var i=0; i<s.length; i++)
  {
    var code = s.charCodeAt(i);
    if (code < 32 || code > 126)
    { 
      // Replacement character
      var replace = "&#" + code + ";";
      // Ignore newline characters and tabs
      // TODO - should we ignore everything < 32 ?
			// AG: Next line is commented out to resolve bug #15532. Why it was needed?..
      //if (code == 9 || code == 10) replace = " ";
      s = s.substring(0, i) + replace + s.substring(i+1);
    }
  }
  return s;
}

/**
 * Encode url problem charaters.
 */
function encodeUrl(s)
{
	if (!s) return "";  // so we know it's not a new feed any more
  s = s.replace(new RegExp('&','gi'), '&amp;');
  return s;
}

/**
 * Return true if this article already exists.
 * We assume that every article has a unique link.
 */
function doesArticleExist(feed, link)
{
  for (var i=0; i<feed.size(); i++)
    if (feed.get(i).link == link) 
      return true;
  for (var i=0; i<feed.deletedsize(); i++)
    if (feed.deletedget(i).link == link) 
      return true;
  return false;
}

function downloadIcon(feed)
{
  if (!options.favicons)
	{ 
		for (var i=0; i<model.size(); i++)
			model.get(i).icon.src = iconOk;
	}
  else
  {
    if (feed.icon.src == null || feed.icon.src == "" || feed.icon.src == iconOk)
    {
      feed.icon.src = iconOk;
			// don't guessHomepage before feed refreshed, if feed.homepage is null
			if (options.guessHomepage && feed.homepage == "")
				feed.homepage = guessHomepage(feed);
      if (feed.homepage != null && feed.homepage != "")
      {
        var favicon = feed.homepage.replace("index.html","");
        if (favicon.charAt(favicon.length-1) != "/") favicon += "/";
        favicon += "favicon.ico";
    		var filename = getProfileDir();
    		filename.append(feed.uid + ".ico");
				var file = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
				file.initWithPath(filename.path);
        getFavIcon(favicon,file);
      }
    }
  }
}

function getFavIcon(favicon,file)
{
	try
	{
	  var IOService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
	  var IOchannel = IOService.newChannel(favicon,null,null);
	  var nfListener = Components.classes["@mozilla.org/network/downloader;1"].createInstance(Components.interfaces.nsIDownloader);
	  nfListener.init(nfObserver,file);
	  IOchannel.asyncOpen(nfListener,null);
	}
	catch(e) {}
}

function isImg(file)
{
// TODO doesn't work with K-M
//  if (!file.exists() || file.fileSize == 0) return false;
  if (file.fileSize == 0) return false;
  var inputStream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance( Components.interfaces.nsIFileInputStream );
  inputStream.init( file,0x01,00004,null);
  var scInputStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance( Components.interfaces.nsIScriptableInputStream );
  scInputStream.init(inputStream);
  var output = scInputStream.read(-1);
  scInputStream.close();
  inputStream.close();
  if (output.toLowerCase().indexOf('html') == -1) return true;
  return false;
}

var nfObserver =
{
  onDownloadComplete: function(adownloader, arequest, actxt , astatus, aresult)
  {
    var aleafName = aresult.leafName;
    var auid = aleafName.substr(0,aleafName.length-4);
    var i=model.size();
		if (i==0) return;
    while(model.get(--i).uid != auid) if (i==0) return;
    if (isImg(aresult))
    {
      model.get(i).icon.src = "file:///" + aresult.path;
      var feedtree = document.getElementById("newsfox.feedTree");
      var index = feedtree.currentIndex;
      refreshModelSelect(index);
    }
// doesn't allow removal, shouldn't need
//		else
//			if (aresult.exists()) aresult.remove(false);
  }
}

function guessHomepage(feed)
{
	var hmpg = feed.url;
	var feedburner = hmpg.indexOf("feeds.feedburner.com");
	hmpg = hmpg.replace("feeds.feedburner.com/","www.");
	var start = hmpg.indexOf("://");
	if (start == -1) return "";
	var end = hmpg.indexOf("/",start+3);
	if (end > -1) hmpg = hmpg.substring(0,end);
	if (feedburner > -1) hmpg += ".com";
	hmpg = hmpg.replace("/rss.","/www.");
	hmpg += "/";
	return hmpg;
}

function newTitle(undone)
{
	var nF = NEWSFOX;
	if (undone > 0) nF += " (" + undone + ")";
	// prevent flicker, only redo if needed
	if (document.title != nF) document.title = nF;
}
